//
//  Detecting_Long_Press_GesturesViewController.m
//  Detecting Long Press Gestures
//
//  Created by Vandad Nahavandipoor on 15/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Detecting_Long_Press_GesturesViewController.h"

@implementation Detecting_Long_Press_GesturesViewController

@synthesize longPressGestureRecognizer;
@synthesize dummyButton;

- (void)didReceiveMemoryWarning{
  [super didReceiveMemoryWarning];
}

- (void) handleLongPressGestures:(UILongPressGestureRecognizer *)paramSender{
  
  /* Chcemy znaleźć punkt środkowy pomiędzy dwoma palcami, które
   powodowały wykrycie gestu długiego naciśnięcia. Liczba palców
   została określona we właściwości numberOfTouchesRequired klasy
   UILongPressGestureRecognizer utworzonej w metodzie egzemplarza
   o nazwie viewDidLoad tego kontrolera widoku. Jeżeli zostanie wykryte,
   że inny gest długiego naciśnięcia również używa tej metody jako swojej
   metody docelowej, ignorujemy ten gest. */
  
  if ([paramSender isEqual:self.longPressGestureRecognizer]){
    
    if (paramSender.numberOfTouchesRequired == 2){
      
      CGPoint touchPoint1 = 
      [paramSender locationOfTouch:0
                            inView:paramSender.view];
      
      CGPoint touchPoint2 = 
      [paramSender locationOfTouch:1
                            inView:paramSender.view];
      
      CGFloat midPointX = (touchPoint1.x + touchPoint2.x) / 2.0f;
      CGFloat midPointY = (touchPoint1.y + touchPoint2.y) / 2.0f;
      
      CGPoint midPoint = CGPointMake(midPointX, midPointY);
      
      self.dummyButton.center = midPoint;
      
    } else {
      /* To jest procedura rozpoznawania gestu długiego naciśnięcia z
         użyciem więcej niż dwóch lub mniej niż dwóch palców */
      
    }
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  self.view.backgroundColor = [UIColor whiteColor];
  
  self.dummyButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
  self.dummyButton.frame = CGRectMake(0.0f,
                                      0.0f, 
                                      72.0f,
                                      37.0f);
  self.dummyButton.center = self.view.center;
  [self.view addSubview:self.dummyButton];
  
  /* Najpierw tworzymy procedurę rozpoznawania gestów. */
  self.longPressGestureRecognizer = 
  [[UILongPressGestureRecognizer alloc] 
   initWithTarget:self
   action:@selector(handleLongPressGestures:)];
  
  /* Określamy liczbę palców, które muszą być położone na ekranie. */
  self.longPressGestureRecognizer.numberOfTouchesRequired = 2;
  
  /* Dozwolone jest przesunięcie palcem na odległość maksymalne 100 punktów, aby gest został rozpoznany. */
  self.longPressGestureRecognizer.allowableMovement = 100.0f;
  
  /* Użytkownik musi położyć na ekranie dwa palce (numberOfTouchesRequired) na
   co najmniej jedną sekundę, aby gest został rozpoznany. */
  self.longPressGestureRecognizer.minimumPressDuration = 1.0;
  
  /* Dodanie procedury rozpoznawania gestów do widoku. */
  [self.view addGestureRecognizer:self.longPressGestureRecognizer];
  
}

- (void) viewDidUnload{  
  [super viewDidUnload];  
  self.longPressGestureRecognizer = nil;
  self.dummyButton = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
